﻿/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
 © i-net software 1998-2013

*/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Inet.Viewer.Data;

namespace Inet.Viewer.WinForms.Export
{
    /// <summary>
    /// Settings panel for text export.
    /// </summary>
    public partial class TextSettingsControl : FormatSettingsControl
    {
        private const string PropNewLine = "newline";
        private const string PropPagebreak = "pagebreak";
        private const string PropEncoding = "encoding";

        /// <summary>
        /// Creates the control.
        /// </summary>
        public TextSettingsControl()
        {
            InitializeComponent();
            cmbLineBreak.SelectedIndex = 0;
        }

        /// <inheritdoc />
        public override Bitmap Icon { get { return FormatResource.txt_48; } }

        /// <inheritdoc />
        public override string Label { get { return "Text"; } }

        /// <inheritdoc />
        public override string FileSuffix { get { return "txt"; } }

        /// <inheritdoc />
        public override void CollectExportParameters(Dictionary<string, string> exportParams)
        {
            exportParams[URLRenderData.ParameterExportFmt] = ReportInfo.FormatTXT;
            string newline = string.Empty;
            switch (cmbLineBreak.SelectedIndex)
            {
                case 0:
                    newline = "\r\n"; // Windows NewLine
                    break;
                case 1:
                    newline = "\r";   // Mac NewLine
                    break;
                case 2:
                    newline = "\n";   // Linux NewLine
                    break;
            }
            exportParams[PropNewLine] = newline;
            if (rbPageBreakFormFeed.Checked)
            {
                exportParams[PropPagebreak] = "\f";
            }
            else if (rbPageBreakOther.Checked)
            {
                exportParams[PropPagebreak] = tbPageBreak.Text;
            }
            exportParams[PropEncoding] = cmbCodepage.Text;
        }

        /// <summary>
        /// Called when the radio button state changed. Enables/disables the corresponding
        /// text box.
        /// </summary>
        /// <param name="sender">the sender</param>
        /// <param name="e">the event arguments</param>
        private void rbPageBreak_Changed(object sender, EventArgs e)
        {
            tbPageBreak.Enabled = rbPageBreakOther.Checked;
        }
    }
}
